/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.filesvr;

import com.ibm.hsc.filesvr.FsByteStream;
import com.ibm.hsc.filesvr.FsConnection;
import com.ibm.hsc.filesvr.FsException;
import com.ibm.hsc.filesvr.FsMessagePacket;

public class FsPacket {
    public static final int HEADER_VERSION_01 = 1;
    public static final int HEADER_VERSION = 1;
    public static final int HEADER_LENGTH_01 = 20;
    public static final int HEADER_LENGTH = 20;
    private static final int HEADER_LENGTH_OFFSET_VERSION_01 = 8;
    public static final int PACKET_LENGTH_MINIMUM = 20;
    public static final int SIGNATURE_01 = 1179844609;
    public static final int SIGNATURE = 1179844609;
    public static final int FEATURE_VERSION_01 = 1;
    public static final int FEATURE_MODIFICATION_01 = 0;
    public static final int FEATURE_VERSION_01_MODIFICATION_00 = 65536;
    public static final int FEATURE_CODE_01 = 65536;
    public static final int FEATURE_CODE = 65536;
    public static final int OP_INVALID = -1;
    public static final int OP_NOOP = 0;
    public static final int OP_MESSAGE = 1;
    public static final int OP_CONNECTION_INFO = 2;
    public static final int OP_CONNECTION_CLOSE = 3;
    public static final int OP_FILE_LIST = 4;
    public static final int OP_FILE_OPEN = 5;
    public static final int OP_FILE_CLOSE = 6;
    public static final int OP_FILE_READ = 7;
    protected static final int OP_END_VALID = 8;
    public static final int FILE_NONE = 0;
    public static final int FILE_OPEN_READ = 1;
    public static final int FILE_CLOSE = 4;
    public static final int FILE_OPEN_READ_CLOSE = 5;
    public static final int SUCCESS = 0;
    public static final int FAILURE = 1;
    public static final int INVALID_SIGNATURE = 16;
    public static final int INVALID_PACKET_LENGTH = 17;
    public static final int INVALID_PACKET_VERSION = 18;
    public static final int INVALID_OP_CODE = 19;
    public static final int INVALID_PACKET_STATE = 20;
    public static final int INVALID_FILE_NAME = 21;
    public static final int INVALID_FILE_NAME_LENGTH = 22;
    public static final int INVALID_FILE_TYPE = 23;
    public static final int INVALID_FILE_LIST_FORMAT = 24;
    public static final int INVALID_FILE_FIELD = 25;
    public static final int MISSING_FILE_FIELD = 26;
    public static final int INVALID_OFFSET = 27;
    public static final int INVALID_FILE_ACTION = 28;
    public static final int INVALID_LENGTH = 29;
    public static final int FILE_NOT_FOUND = 256;
    public static final int SOCKET_FAILURE = 512;
    public static final int SOCKET_CLOSED = 513;
    public static final int IO_FAILURE = 768;
    protected static final int FILE_NAME_FIELD = 1;
    protected static final int FILE_SIZE_FIELD = 2;
    protected static final int FILE_DATE_FIELD = 3;
    protected FsConnection m_connection = null;
    protected int m_signature = 1179844609;
    protected int m_featureCode = 65536;
    protected int m_length = 20;
    protected boolean m_responsePacket = true;
    protected int m_opCode = 0;
    protected int m_returnCode = 0;

    public FsPacket(FsConnection fsConnection) {
        this.m_connection = fsConnection;
    }

    protected FsPacket(FsConnection fsConnection, int n) {
        this.m_connection = fsConnection;
        this.m_opCode = n;
    }

    protected FsPacket(FsPacket fsPacket) {
        if (fsPacket != null) {
            this.m_connection = fsPacket.m_connection;
            this.m_signature = fsPacket.m_signature;
            this.m_featureCode = fsPacket.m_featureCode;
            this.m_length = fsPacket.m_length;
            this.m_responsePacket = fsPacket.m_responsePacket;
            this.m_opCode = fsPacket.m_opCode;
            this.m_returnCode = fsPacket.m_returnCode;
        }
    }

    protected FsPacket(FsPacket fsPacket, int n) {
        if (fsPacket != null) {
            this.m_connection = fsPacket.m_connection;
            this.m_signature = fsPacket.m_signature;
            this.m_featureCode = fsPacket.m_featureCode;
            this.m_length = fsPacket.m_length;
            this.m_responsePacket = fsPacket.m_responsePacket;
            this.m_returnCode = fsPacket.m_returnCode;
        }
        this.m_opCode = n;
    }

    public FsPacket build(FsByteStream fsByteStream) {
        try {
            this.buildData(fsByteStream);
            int n = fsByteStream.getPosition();
            if (this.m_length != n) {
                this.m_length = n;
                if (this.m_signature == 1179844609) {
                    fsByteStream.setPosition(8);
                }
                fsByteStream.writeInt(this.m_length);
                fsByteStream.setPosition(this.m_length);
            }
            return null;
        }
        catch (FsException fsException) {
            this.m_connection.trace("FsPacket.build: Exception caught", fsException);
            return new FsMessagePacket(this.m_connection, fsException.getId());
        }
    }

    protected void buildData(FsByteStream fsByteStream) throws FsException {
        fsByteStream.clear();
        if (this.m_signature != 1179844609) {
            throw new FsException(16, this.m_signature);
        }
        fsByteStream.writeInt(this.m_signature);
        fsByteStream.writeInt(this.m_featureCode);
        fsByteStream.writeInt(this.m_length);
        fsByteStream.writeByte(this.getStatusFlags());
        fsByteStream.writeInt(this.m_opCode, 3);
        fsByteStream.writeInt(this.m_returnCode);
    }

    public int getFeatureCode() {
        return this.m_featureCode;
    }

    public int getFeatureModification() {
        return this.m_featureCode & 0xFFFF;
    }

    public int getFeatureVersion() {
        return this.m_featureCode >> 16;
    }

    public int getLength() {
        return this.m_length;
    }

    public static int getMinimumLength() {
        return 20;
    }

    public int getOpCode() {
        return this.m_opCode;
    }

    public int getReturnCode() {
        return this.m_returnCode;
    }

    public FsPacket getResponsePacket() {
        return this;
    }

    protected int getSignature() {
        return this.m_signature;
    }

    private byte getStatusFlags() {
        byte by = 0;
        if (this.m_responsePacket) {
            by = (byte)(by + 128);
        }
        return by;
    }

    public boolean isError() {
        return this.m_returnCode > 0;
    }

    public boolean isRequestPacket() {
        return !this.m_responsePacket;
    }

    public boolean isResponsePacket() {
        return this.m_responsePacket;
    }

    public boolean isValid() {
        return this.getSignature() == 1179844609 && this.getFeatureVersion() == 1 && this.m_length >= 20 && this.m_opCode < -1;
    }

    public FsPacket parse(FsByteStream fsByteStream) {
        try {
            this.parseData(fsByteStream);
            return null;
        }
        catch (FsException fsException) {
            this.m_connection.trace("FsPacket.parse: Exception caught", fsException);
            return new FsMessagePacket(this.m_connection, fsException.getId());
        }
    }

    protected void parseData(FsByteStream fsByteStream) throws FsException {
        this.setSignature(fsByteStream.readInt());
        if (this.getSignature() != 1179844609) {
            throw new FsException(16, this.m_signature);
        }
        this.setFeatureCode(fsByteStream.readInt());
        this.setLength(fsByteStream.readInt());
        this.setStatusFlags(fsByteStream.readByte());
        this.setOpCode(fsByteStream.readInt(3));
        this.setReturnCode(fsByteStream.readInt());
    }

    public void setFeatureCode(int n) {
        this.m_featureCode = n;
    }

    private void setLength(int n) {
        this.m_length = n;
    }

    protected void setOpCode(int n) {
        this.m_opCode = n;
    }

    protected void setRequestPacket() {
        this.m_responsePacket = false;
    }

    protected void setResponsePacket() {
        this.m_responsePacket = true;
    }

    protected void setReturnCode(int n) {
        this.m_returnCode = n;
    }

    private void setSignature(int n) {
        this.m_signature = n;
    }

    private void setStatusFlags(byte by) {
        this.m_responsePacket = (by & 0xFFFFFF80) != 0;
    }
}

